/*========================================================
 * CS driver API function for Linux-OS
 *
 * Copyright (c) Matsushita Electric Industrial Co., Ltd.
 * All Rights Reserved.
 *
 *========================================================*/
#include <sd_api.h>

#include "SddApi.h"
#include "sd_ioctl.h"

/*=====================================================================
***		O[oϐ
=====================================================================*/
STR_SDIF_INTERNAL_DRIVER	gSDStatus;
SDD_HANDLE *ptSDD_Handle_Nor;

/*=====================================================================
*** $Resume	o͐R}hƏ֐
*** $Desc	o͐R}hƂ̏֐̍\
*** $Note	Ȃ
=====================================================================*/
typedef struct {
	int		unCmd;	/* o͐R}h */
	ULONG	( *piFunc )( ULONG ulArg);/* o͐R}h֐ */
} STR_SD_IOCTL_CMD_SET;

/*=====================================================================
*** $Resume	o͐R}he[u
*** $Desc	o͐pR}he[u
*** $Note	Ȃ
=====================================================================*/
static const STR_SD_IOCTL_CMD_SET	sd_ioctl_table[] = {
	{SD_IOC_GET_CARDSIZE,	SD_P_IocGetCardSize},	/* J[hSTCY擾 */
//	{SD_IOC_SET_READ_PRE,	SD_P_IocSetReadPre},	/* SD_F_Readp[^ݒ */
//	{SD_IOC_SET_WRITE_PRE,	SD_P_IocSetWritePre},	/* SD_F_Writep[^ݒ */
	{SD_IOC_GET_NOMSIZE,	SD_P_IocGetNomSize},	/* ʏ̈TCY擾 */
	{SD_IOC_GET_WP_CHECK,	SD_P_Ioc_WP_Check},	/* CgveNg`FbN */
	{SD_IOC_SET_INIT,	SD_P_Ioc_MPInit},	/* J[hhCo*/
	{SD_IOC_REQUEST_IRQ,	SD_P_IocRequestIrq},	/* NCAghCo荞݃nho^ */
	{SD_IOC_FREE_IRQ,	SD_P_IocFreeIrq},	/* NCAghCo荞݃nho^폜 */
	{SD_IOC_GET_STATUS,	SD_P_IocGetStatus},	/* J[hhCoݏԎ擾 */
	{SD_IOC_GET_INFO,	SD_P_IocGetInfo},	/* J[hhCo擾 */
#if 1	/* SDRAgݍ*/
	/* ^C}@\͖gp֐e[u͕Kv	*/
	{SD_IOC_SET_TIMER_START,	SD_P_Ioc_TimerStart},	/* ^C}X^[g */
	{SD_IOC_SET_TIMER_STOP,		SD_P_Ioc_TimerStop},	/* ^C}Xgbv */
#endif	/* SDRAgݍ*/
	{SD_IOC_SET_INSDEL_INTR,	SD_P_Ioc_InsDel_Intr},	/* J[h}roEnable,Disableݒ */
	{SD_IOC_READ_EXTR_SINGLE,	SD_P_IocReadExtrSingle},	/* CMD48 Extension Register Reads */
	{SD_IOC_WRITE_EXTR_SINGLE,	SD_P_IocWriteExtrSingle},	/* CMD49 Extension Register Writes */
#ifdef _SDD_FUNC_SECURE_
#endif /* _SDD_FUNC_SECURE_ */
#if 1	/* SDRA C2@\g	*/
#ifdef _SDD_C2_
#endif /* _SDD_C2_ */
#endif	/* SDRA C2@\g	*/
#if 1	/* SDRAgݍ	*/
#else	/* SDRAgݍ	*/
#ifdef SDIO
	{SD_IOC_SET_IO_READ_DIRECT,SD_P_IocSetIoReadDirect},	/* R}h52@Reads */
	{SD_IOC_SET_IO_WRITE_DIRECT,SD_P_IocSetIoWriteDirect},	/* R}h52@Writes */
	{SD_IOC_GET_IO_R5,	SD_P_IocGetIoR5},	/* X|Xf[^擾 */
	{SD_IOC_SET_IO_READ_EXTENDED,SD_P_IocSetIoReadExtended},	/* R}h53@}`ANZX[h */
	{SD_IOC_SET_IO_WRITE_EXTENDED,SD_P_IocSetIoWriteExtended},	/* R}h53@}`ANZXCg */
	{SD_IOC_SET_IO_GO_INACTIVE,SD_P_IocSetIoGoInactive},	/* J[hԂINACTIVEɐݒ */
	{SD_IOC_SET_IO_FUNC_ENABLE,SD_P_IocSetIoFuncEnable},	/* J[he@\̎gp/sgpݒ */
	{SD_IOC_GET_IO_FUNCREADY,SD_P_IocGetIoFuncReady},	/* J[he@\̏Ԏ擾 */
	{SD_IOC_GET_IO_STATUS,	SD_P_IocGetIoStatus},		/* J[h̎擾 */
	{SD_IOC_SET_IO_BUSWIDTH,SD_P_IocSetIoBusWidth},	/* J[h̃rbgI */
	{SD_IOC_SET_IO_BLOCKLENGTH,SD_P_IocSetIoBlockLength},	/* CMD53f[^]ubNݒ */
//	{SD_IOC_SET_IO_FUNCIRQ_ENABLE,SD_P_IocSetIoFuncIrqEnable},	/* J[he@\̊荞݋/֎~ݒ */
//	{SD_IOC_GET_IO_FUNCIRQ,	SD_P_IocGetIoFuncIrq},	/* J[he@\̊荞ݏԎ擾 */
//	{SD_IOC_GET_IO_FUNCCODE,SD_P_IocGetIoFuncCode},	/* J[h̋@\R[h擾 */
//	{SD_IOC_SET_IO_CSA_ENABLE,SD_P_IocSetIoCsaEnable},	/* CSAT|[gݒ */
//	{SD_IOC_GET_IO_CSA_POINTER,SD_P_IocGetIoCsaPointer},	/* CSA|C^擾 */
//	{SD_IOC_SET_IO_HOSTIRQ_ENABLE,SD_P_IocSetIoHostIrqEnable},	/* zXgIP̊荞݋/֎~ݒ */
//	{SD_IOC_GET_IO_CCCR,	SD_P_IocGetIoCCCR},	/* CCCR擾 */
//	{SD_IOC_GET_IO_FBR,	SD_P_IocGetIoFBR},	/* FBR擾 */
//	{SD_IOC_GET_IO_CIS,	SD_P_IocGetIoCIS},	/* CIS擾 */
//	{SD_IOC_GET_CARD_TYPE,	SD_P_IocGetCardType},	/* J[hʎ擾 */
#endif	//SDIO
#endif	/* SDRAgݍ	*/

/* 20120905 Delete */
//#if SUI /*@oCh*/

#ifdef SUI /*@oCh*/
//	{SD_IOC_SET_SUI,	SD_P_IocSetSUI},	/* @ŗLݒ@@oCh */
//	{SD_IOC_SET_ENCDEC_INIT,SD_P_IocSetEncDecInit},	/* ÍE@@oCh */
//	{SD_IOC_SET_ENCDEC,	SD_P_IocSetEncDec},	/* ÍEݒ@@oCh */
//	{SD_IOC_SET_MKBSEL,	SD_P_IocSetMKBSEL},	/* ROM f[^̃oN؂ւ@@oCh */
//	{SD_IOC_SET_CCDIV_OUT,	SD_P_IocSetCcDivOut},	/* f[^o͐I @oCh */
//	{SD_IOC_SET_RAMIRQ_SIZE,SD_P_IocSetRamIrqSize},	/* ^obt@ RAM 荞݂̃f[^TCYݒ@@oCh */
#endif	// SUI
	{0xFFFF,		NULL}		/* ΉR}h */
};


/*************************************************/
/*      OAPI                                  */
/*************************************************/
/***********************************************************/
/* ֐FSD_F_Open                                       */
/* @\  FSD I/F@\ubÑI[v                */
/*   FȂ                                            */
/* ߂lFint ; CShCõI[vNumber                */
/***********************************************************/
int SD_F_Open( void )
{
	int iRet = 0;
	SDD_ERROR SddErr = SDD_SUCCESS;
	SD_CS_LOCK;		//  semaphore

	if(gSDStatus.open_cnt >= SD_CS_CLIENT_MAX){	// maxI[vς
		iRet = -EALREADY;
	}else{
		if(gSDStatus.open_cnt == 0){	/* ̃I[v̂SDRAI[v	*/
										/*  SDRA͑dI[v֎~			*/
			ptSDD_Handle_Nor = (SDD_HANDLE *)kmalloc((sizeof(SDD_HANDLE))*2,GFP_ATOMIC | __GFP_DMA);

			SddErr = SDD_Open(SDD_DEVICEID_NORMAL,ptSDD_Handle_Nor);
			if(SddErr != SDD_SUCCESS){
				iRet = -EALREADY;
				kfree((void *)ptSDD_Handle_Nor);	/* mۗ̈̊J	*/
			}else{
#ifdef _SDD_FUNC_SECURE_	/* 20080925 NonSecure */
#endif /*_SDD_FUNC_SECURE_*/	/* 20080925 NonSecure */
			}
		}

		if(SddErr == SDD_SUCCESS){
			iRet = gSDStatus.open_cnt;
			gSDStatus.open_cnt ++;	// I[vJEgCNg
		}
	}

	SD_CS_UNLOCK;	//  semaphore

	return iRet;
}
EXPORT_SYMBOL(SD_F_Open);

/******************************************************************/
/* ֐FSD_F_Close                                             */
/* @\  FSD I/F@\ubÑN[Y                       */
/*   Ffilp ; iNot LinuxjfoCX                       */
/*                 iLinuxjSD_F_OpenŎ擾NCAgNO     */
/* ߂lF0iɐj                                          */
/******************************************************************/
int  SD_F_Close( int filp )
{
	int iRet = SD_SUCCESS;
	SDD_ERROR SddErr = SDD_SUCCESS;

	SD_CS_LOCK;		//   semaphore

	if(gSDStatus.event_handler[filp] != NULL){
		gSDStatus.event_handler[filp] = NULL;	// NCAg̊荞݃nh폜
	}

	if(gSDStatus.open_cnt <= 0){	// I[vOȉH
		iRet = -EALREADY;
	}else{
		gSDStatus.open_cnt --;	// I[vJEgfNg

		if(gSDStatus.open_cnt == 0){		/* SăN[Y̏ꍇ̂SDRAN[Y	*/
											/*  SDRA͑dI[v֎~				*/
			SddErr = SDD_Close(ptSDD_Handle_Nor);
			if(SddErr != SDD_SUCCESS){
				gSDStatus.open_cnt ++;	// I[vJEgCNg
				iRet = gSDStatus.open_cnt;
			}else{
				kfree((void *)ptSDD_Handle_Nor);	/* mۗ̈̊J	*/
			}
		}
	}

	SD_CS_UNLOCK;	//   semaphore

	return iRet;
}
EXPORT_SYMBOL(SD_F_Close);


/******************************************************************/
/* ֐FSD_F_Read                                              */
/* @\  FSD I/F@\ubÑ[h                         */
/*   Ffilp      ; iNot LinuxjfoCX                  */
/*                     iLinuxj    SD_F_Openł̃NCAgNO   */
/*         pvBuf     ; ǂݏof[^i[obt@                 */
/*         ulBufsize ; ǂݏoTCYiZN^j                 */
/*         ulOffset  ; ǂݏoJnItZbg                     */
/*         usArea    ; ǂݏöiʏ^F؁j                 */
/*         *info     ; FS_INFO\̃|C^                      */
/* ߂lFint^i[h֐̌ 0: ̑:ُI         */
/******************************************************************/
int  SD_F_Read( int filp, void *pvBuf, ULONG ulBufsize, ULONG ulOffset, USHORT usArea, FS_INFO *info )
{
	int iRet = SD_SUCCESS;
	SDD_ERROR SddErr;

	SD_CS_LOCK;	//  semaphore

	gSDStatus.unCardErrStatus = SD_SUCCESS;

#ifndef NO_HARDWARE
	if (usArea == SD_SECURE_AREA ){
#ifdef _SDD_FUNC_SECURE_	/* 20080925 NonSecure */
#endif /*_SDD_FUNC_SECURE_*/	/* 20080925 NonSecure */
	}
	else {
		if ( ulBufsize == 0 ) {	/* `FbNǉ  ǂݍ݃TCY0Ȃ΃G[ */
			iRet = (int)SDD_ERR_PARAM;
		}
		else {
			SddErr = SDD_Read(ptSDD_Handle_Nor, pvBuf, ulBufsize, ulOffset);
			if(SddErr != SDD_SUCCESS){
				iRet = SddErr;
			}
		}
	}
#endif	// NO_HARDWARE
	gSDStatus.unStreamReadFlag = FALSE;	/* StreamRead Flag Clear */
	gSDStatus.unSearchFlag = FALSE;		/* Search Flag Clear */

//	SD_AndFPGA(SDIO_INFO1_MASK,~(SDIO_INFO1_MASK_IOMSK));

	SD_CS_UNLOCK;	//  semaphore

	return iRet;
}
EXPORT_SYMBOL(SD_F_Read);


/******************************************************************/
/* ֐FSD_F_Write                                             */
/* @\  FSD I/F@\ubÑCg                         */
/*   Ffilp      ; iNot LinuxjfoCX                  */
/*                     iLinuxj    SD_F_Openł̃NCAgNO   */
/*         pvBuf     ; ݃f[^i[obt@                 */
/*         ulBufsize ; ݃TCYiZN^j                 */
/*         ulOffset  ; ݊JnItZbg                     */
/*         usArea    ; ݗ̈iʏ^F؁j                   */
/*         *info     ; FS_INFO\̃|C^                      */
/* ߂lFint^iCg֐̌ 0: ̑:ُI         */
/******************************************************************/
int  SD_F_Write( int filp, void *pvBuf, ULONG ulBufsize, ULONG ulOffset, USHORT usArea, FS_INFO *info )
{
	int	iRet = SD_SUCCESS;
	SDD_ERROR SddErr;

	SD_CS_LOCK;	//  semaphore

	gSDStatus.unCardErrStatus = SD_SUCCESS;

#ifndef NO_HARDWARE
	if (usArea == SD_SECURE_AREA ){
		if ( pvBuf == NULL ){
#if 0	/* 쐬	*/
		SDD_ERROR Sdd_IocMakeEraseArg(UW uw_Arg)
		SDD_ERROR Sdd_IocSecureErase(UW uw_Arg)
#endif
		}
#if 0	/* SDRAg	*/
		else if ( ulBufsize == 0 ){	/* G[`FbN */
			iRet = (int)SDD_ERR_PARAM;
		}
#endif	/* SDRAg	*/
		else{
#ifdef _SDD_FUNC_SECURE_	/* 20080925 NonSecure */
#endif /* _SDD_FUNC_SECURE_ */	/* 20080925 NonSecure */
		}
	}
	else {
		if ( ulBufsize == 0 ) {	/* `FbNǉ  ǂݍ݃TCY0Ȃ΃G[ */
			iRet = (int)SDD_ERR_PARAM;
		}
		else {
			SddErr = SDD_Write(ptSDD_Handle_Nor, pvBuf, ulBufsize, ulOffset);
			if(SddErr != SDD_SUCCESS){
				iRet = SddErr;
			}
		}
	}
#endif	// NO_HARDWARE
	gSDStatus.unStreamReadFlag = FALSE;	/* StreamRead Flag Clear */

	SD_CS_UNLOCK;	//  semaphore

	return iRet;

}
EXPORT_SYMBOL(SD_F_Write);


/***********************************************************/
/* ֐FSD_F_Ioctl                                      */
/* @\  FSD I/F@\ubN̓o͐䏈              */
/*   Ffilp ; (Not Linux)foCX                  */
/*                (Linux)    SD_F_Openł̃NCAgNO   */
/*         unCmd; o͐R}h                       */
/*         ulArg; R}hi܂͂̃|C^j       */
/* ߂lFSD_SUCCESS; I                            */
/*         ̑    ; ُI                            */
/***********************************************************/
int SD_F_Ioctl(int filp, UINT32 unCmd, ULONG ulArg )
{

	int	iRet = SD_SUCCESS;

	/* don't even decode wrong cmds: better returning  ENOTTY than EFAULT */
	if (_IOC_TYPE(unCmd) != SD_IOC_MAGIC) {
		return -ENOTTY;
	}
	if (_IOC_NR(unCmd) > SD_IOC_CMD_MAX) {
		return -ENOTTY;
	}
	SD_CS_LOCK;	//  semaphore

	gSDStatus.fd = filp;
	gSDStatus.unCardErrStatus = SD_SUCCESS;

#ifndef NO_HARDWARE
	/* G[v */
	if(gSDStatus.make_err.iCmd == unCmd){
		iRet = gSDStatus.make_err.usErr;
		gSDStatus.make_err.iCmd = 0;
		goto end_of_ioctl;
	}

	if( sd_ioctl_table[_IOC_NR(unCmd) - 1].piFunc != NULL ) {
		iRet = (int)sd_ioctl_table[_IOC_NR(unCmd) - 1].piFunc( ulArg );
	}else{
		iRet = (int)SDD_ERR_PARAM;
	}
#endif	// NO_HARDWARE

end_of_ioctl:
	SD_CS_UNLOCK;	//  semaphore

	return iRet;
}
EXPORT_SYMBOL(SD_F_Ioctl);

